<?php
/**
* Modulo MercadoPago
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Commercial use allowed (Non-assignable & non-transferable), can modify source-code but cannot distribute modifications (derivative works).
*/

/**
 * the name of the class should be [ModuleName][ControllerName]ModuleFrontController
 */
class MpmxsRedirectModuleFrontController extends ModuleFrontController
{
    public function __construct()
    {
        parent::__construct();
        $this->context = Context::getContext();
    }

    /**
     * @see FrontController::initContent()
     */
    public function initContent()
    {
        parent::initContent();
        if (!isset($this->module->gateway) || !$this->module->gateway) {
            if (Tools::isSubmit('id_product')) {
                die('{"error": "mercadopago_not_installed"}');
            } else {
                Tools::redirect('index');
            }
            exit;
        }
        if (Tools::isSubmit('id_product')) {
            $this->module->gateway->checkPrice();
            exit;
        }
        if (Tools::isSubmit('topic')) {
            $this->module->gateway->ipn();
            exit;
        }
        if (Tools::isSubmit('collection_status')
            || Tools::isSubmit('collection_id')
            || Tools::isSubmit('merchant_order_id')) {
            $this->module->gateway->returnMP();
            exit;
        }
        Tools::redirect('index');
    }
}
