{*
* Pagina administrativa
*
* @author     Modulo MercadoPago>
* @copyright Kubo Digital
* @license   Comercial
*}
<form action="" method="post" id="formKMP" enctype="multipart/form-data" class="form-horizontal">
    <ps-panel icon="icon-cogs" header="{$display_name|escape:'htmlall':'UTF-8'}">

        <ps-input-text name="client_id" 
            label="{l s='client_id' mod='mpmxs'}"
            help="{l s='client_id' mod='mpmxs'}" size="10" 
            value="{if isset($client_id)}{$client_id|escape:'htmlall':'UTF-8'}{/if}"
            required-input="true" 
            hint="{l s='Enter your client_id' mod='mpmxs'}"></ps-input-text>
            
        <ps-input-text name="client_secret" 
            label="{l s='client_secret' mod='mpmxs'}"
            help="{l s='client_secret' mod='mpmxs'}" size="10" 
            value="{if isset($client_id)}{$client_secret|escape:'htmlall':'UTF-8'}{/if}"
            required-input="true" 
            hint="{l s='Enter your client_secret' mod='mpmxs'}"></ps-input-text>
        
        <ps-label-information>
            <ps-alert-warn><a href="{$settings.SECRET_URL|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Search your client_id and client_secret here' mod='mpmxs'}</a></ps-alert-error>
        </ps-label-information>
        
        {if isset($client_id) and isset($client_secret) and $api_me}
            <ps-input-text name="fee" 
                label="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mpmxs'}"
                help="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mpmxs'}" size="10" 
                value="{if isset($fee)}{$fee|escape:'htmlall':'UTF-8'}{/if}"
                required-input="true" fixed-width="lg"
                hint="{l s='Percent of Commission charge to customer for using MercadoPago' mod='mpmxs'}"></ps-input-text>
                
            <ps-input-text name="fee_amount" 
                label="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mpmxs'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"
                help="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mpmxs'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}" size="10" 
                value="{if isset($fee_amount)}{$fee_amount|escape:'htmlall':'UTF-8'}{/if}"
                required-input="true" fixed-width="lg"
                hint="{l s='Amount of commission charge to customer for using MercadoPago, in' mod='mpmxs'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"></ps-input-text>
                
            {if isset($settings.PUBLICKEY_URL)}
            <ps-switch name="installment_calculator" 
                label="{l s='Show Installment Calculator on Payment Button' mod='mpmxs'}" 
                yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                {if isset($installment_calculator) && $installment_calculator}active="true"{/if}></ps-switch>
           
           <ps-switch name="installment_product_calculator" 
                label="{l s='Show Installment Calculator on product sheet' mod='mpmxs'}" 
                yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                {if isset($installment_product_calculator) && $installment_product_calculator}active="true"{/if}></ps-switch>
             
            <div id="installment_div" {if isset($installment_calculator) && !$installment_calculator}style="display:none">{/if}>
                

                <ps-input-text name="publickey" 
                    label="{l s='Sandbox Public Key' mod='mpmxs'}"
                    help="{l s='Enter your Sandbox Public Key' mod='mpmxs'}" size="10" 
                    value="{if isset($publickey)}{$publickey|escape:'htmlall':'UTF-8'}{/if}"
                    hint="{l s='Enter your Sandbox Public Key' mod='mpmxs'}"></ps-input-text>
                
                <ps-label-information>
                    <ps-alert-warn><a href="{$settings.PUBLICKEY_URL|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Search your Sandbox Public Key here' mod='mpmxs'}</a></ps-alert-error>
                </ps-label-information>
            </div>
            {/if}
            <ps-checkboxes label="{l s='Exclude Payment Method' mod='mpmxs'}">
                <ps-checkbox name="exclude_payments[bank_transfer]" {if isset($exclude_payments) and isset($exclude_payments.bank_transfer)}checked="true"{/if} value="1">
                    {l s='Bank Transfer' mod='mpmxs'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[atm]" value="1" {if isset($exclude_payments) and isset($exclude_payments.atm)}checked="true"{/if}>
                    {l s='ATM Bank Transfer' mod='mpmxs'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[ticket]" {if isset($exclude_payments) and isset($exclude_payments.ticket)}checked="true"{/if} value="1">
                    {l s='Ticket' mod='mpmxs'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[credit_card]" {if isset($exclude_payments) and isset($exclude_payments.credit_card)}checked="true"{/if} value="1">
                    {l s='Payment by credit card' mod='mpmxs'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[debit_card]" {if isset($exclude_payments) and isset($exclude_payments.debit_card)}checked="true"{/if} value="1">
                    {l s='Payment by debit card' mod='mpmxs'}
                </ps-checkbox>
                <ps-checkbox name="exclude_payments[prepaid_card]" {if isset($exclude_payments) and isset($exclude_payments.prepaid_card)}checked="true"{/if} value="1">
                    {l s='Payment by prepaid card' mod='mpmxs'}
                </ps-checkbox>
                {if $settings.ACCEPT_DIGITAL_CURRENCY}
                    <ps-checkbox name="exclude_payments[digital_currency]" {if isset($exclude_payments) and isset($exclude_payments.digital_currency)}checked="true"{/if} value="1">
                        {l s='Payment by digital currency (Bitcoin, etc..)' mod='mpmxs'}
                    </ps-checkbox>
                {/if}
            </ps-checkboxes>
            <ps-radios label="{l s='Image for Order and Checkout on MercadoPago' mod='mpmxs'}">
                <ps-radio name="image_for_order" value="custom" {if !isset($image_for_order) or $image_for_order == 'custom'}checked="true"{/if}>{l s='Custom Image' mod='mpmxs'}</ps-radio>
                <ps-radio name="image_for_order" value="product" {if isset($image_for_order) and $image_for_order == 'product'}checked="true"{/if}>{l s='Use the first product image of the order' mod='mpmxs'}</ps-radio>
            </ps-radios>
            <div id="logo_mercadopago_checkout" {if isset($image_for_order) && $image_for_order == 'product'}style="display:none">{/if}>
                <ps-input-file name="file_mercadopago_checkout" 
                    label="{l s='Logo for Order and Checkout on MercadoPago' mod='mpmxs'}"
                    help="{l s='Logo for Order and Checkout on MercadoPago' mod='mpmxs'}" size="10"
                    hint="{l s='Logo for Order and Checkout on MercadoPago' mod='mpmxs'}"></ps-input-file>
                {if isset($logo_mercadopago_checkout) && $logo_mercadopago_checkout}
                <ps-label-information>
                    <img {if isset($logo_mercadopago_checkout_size) && $logo_mercadopago_checkout_size > 0}width="100%" style="max-width: {$logo_mercadopago_checkout_size.0|escape:'htmlall':'UTF-8'}px"{/if} src="{$logo_mercadopago_checkout|escape:'htmlall':'UTF-8'}?cache={math equation='rand()'}" />
                </ps-label-information>
            </div>
            {if $ps_version < '1.7'}
            <ps-switch name="custom_payment_button" 
                label="{l s='Use Custom Button Payment' mod='mpmxs'}" 
                yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                {if isset($custom_payment_button) && $custom_payment_button}active="true"{/if}></ps-switch>
            
            <div id="default_payment_button" {if isset($custom_payment_button) && $custom_payment_button}style="display:none">{/if}>
                <ps-radios label="{l s='Color button' mod='mpmxs'}">
                    <ps-radio name="style[b_color]" value="blue" {if !isset($style) or $style.b_color == 'blue'}checked="true"{/if}>{l s='Blue' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_color]" value="orange" {if isset($style) and $style.b_color == 'orange'}checked="true"{/if}>{l s='Orange' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_color]" value="red" {if isset($style) and $style.b_color == 'red'}checked="true"{/if}>{l s='Red' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_color]" value="green" {if isset($style) and $style.b_color == 'green'}checked="true"{/if}>{l s='Green' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_color]" value="lightblue" {if isset($style) and $style.b_color == 'lightblue'}checked="true"{/if}>{l s='LightBlue' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_color]" value="grey" {if isset($style) and $style.b_color == 'grey'}checked="true"{/if}>{l s='Grey' mod='mpmxs'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Size button' mod='mpmxs'}">
                    <ps-radio name="style[b_size]" value="L" {if !isset($style) or !isset($style.b_size) or $style.b_size == 'L'}checked="true"{/if}>{l s='Large' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_size]" value="M" {if isset($style) and $style.b_size == 'M'}checked="true"{/if}>{l s='Medium' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_size]" value="S" {if isset($style) and $style.b_size == 'S'}checked="true"{/if}>{l s='Small' mod='mpmxs'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Shape style button' mod='mpmxs'}">
                    <ps-radio name="style[b_shape]" value="Sq" {if !isset($style) or !isset($style.b_shape) or $style.b_shape == 'Sq'}checked="true"{/if}>{l s='Square' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_shape]" value="Rn" {if isset($style) and $style.b_shape == 'Rn'}checked="true"{/if}>{l s='Rounded' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_shape]" value="Ov" {if isset($style) and $style.b_shape == 'Ov'}checked="true"{/if}>{l s='Oval' mod='mpmxs'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Font style button' mod='mpmxs'}">
                    <ps-radio name="style[b_font]" value="Ar" {if !isset($style) or !isset($style.b_font) or $style.b_font == 'Ar'}checked="true"{/if}>{l s='Arial' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_font]" value="Tr" {if isset($style) and $style.b_font == 'Tr'}checked="true"{/if}>{l s='Trebuchet' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_font]" value="Ge" {if isset($style) and $style.b_font == 'Ge'}checked="true"{/if}>{l s='Georgia' mod='mpmxs'}</ps-radio>
                </ps-radios>
                <ps-radios label="{l s='Logos in button' mod='mpmxs'}">
                    <ps-radio name="style[b_logo]" value="All" {if !isset($style) or !isset($style.b_logo) or $style.b_logo == 'All'}checked="true"{/if}>{l s='All payment methods' mod='mpmxs'}</ps-radio>
                    <ps-radio name="style[b_logo]" value="On" {if isset($style) and $style.b_logo == 'On'}checked="true"{/if}>{l s='Only for immediate accreditation payment methods' mod='mpmxs'}</ps-radio>
                </ps-radios>
            </div>
            <div id="custom_payment_button" {if !isset($custom_payment_button) or not $custom_payment_button}style="display:none"{/if}>
                <ps-input-file name="file_custom_button" 
                    label="{l s='Attach Custom Button Image' mod='mpmxs'}"
                    help="{l s='Attach Custom Button Image' mod='mpmxs'}" size="10"
                    hint="{l s='Attach Custom Button Image' mod='mpmxs'}"></ps-input-file>
                {if isset($custom_payment_button) && $custom_payment_button}
                <ps-label-information>
                    <img width="100%" style="max-width: {$custom_payment_button_size.0|escape:'htmlall':'UTF-8'}px" src="{$custom_payment_button|escape:'htmlall':'UTF-8'}?cache={math equation='rand()'}" />
                </ps-label-information>
                {/if}
            </div>
            {/if}
            {/if}
            <ps-select name="os_authorization" label="{l s='Accepted payment status' mod='mpmxs'}">
                {foreach from=$order_states item=val}
                    <option value="{$val.id_order_state|escape:'htmlall':'UTF-8'}" {if isset($os_authorization) and $val.id_order_state == $os_authorization}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </ps-select>
            <ps-select name="os_refused" label="{l s='Error or Invalid payment status' mod='mpmxs'}">
                {foreach from=$order_states item=val}
                    <option value="{$val.id_order_state|escape:'htmlall':'UTF-8'}" {if isset($os_refused) and  $val.id_order_state == $os_refused}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </ps-select>
            <ps-select name="status_refound[]" multiple="true" label="{l s='Refound money if the order has one of these status' mod='mpmxs'}">
                {foreach from=$order_states item=val}
                    <option value="{$val.id_order_state|escape:'htmlall':'UTF-8'}" {if isset($status_refound) and in_array($val.id_order_state, $status_refound)}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                {/foreach}
            </ps-select>
            <ps-switch name="modal" 
                label="{l s='Modal Window (By clicking on "Pay" MercadoPago window opens on the Same Page)' mod='mpmxs'}" 
                yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                {if isset($modal) && $modal}active="true"{/if}></ps-switch>
            <!-- 
            {if $ps_version < '1.7'}
            {else}
            <input type="hidden" name="modal" value="0" />
            {/if} -->
            <ps-switch name="auto_return" 
                label="{l s='Auto return when the payment is approved' mod='mpmxs'}" 
                yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                {if isset($auto_return) && $auto_return}active="true"{/if}></ps-switch>
                
            {if isset($settings.PUBLICKEY_URL)}
            <ps-input-text name="min_amount_installments" 
                label="{l s='Minimum amount of the order to activate payment in installments, in' mod='mpmxs'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"
                help="{l s='Minimum amount of the order to activate payment in installments, in' mod='mpmxs'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}" size="10" 
                value="{if isset($min_amount_installments)}{$min_amount_installments|escape:'htmlall':'UTF-8'}{/if}"
                required-input="true" fixed-width="lg"
                hint="{l s='Minimum amount of the order to activate payment in installments, in' mod='mpmxs'} {$settings.CURRENCY|escape:'htmlall':'UTF-8'}"></ps-input-text>
            
            <ps-input-text name="max_installments" 
                label="{l s='Maximum monthly payments to pay for the product' mod='mpmxs'}"
                help="{l s='Permitted range: 1-24' mod='mpmxs'}" size="10" 
                value="{if isset($max_installments)}{$max_installments|escape:'htmlall':'UTF-8'}{/if}"
                required-input="true" fixed-width="lg"
                hint="{l s='Permitted range: 1-24' mod='mpmxs'}"></ps-input-text>
            {else}
            <input name="installment_calculator" type="hidden" value="0" />
            <input name="installment_product_calculator" type="hidden" value="0" />
            <input name="min_amount_installments" type="hidden" value="0" />
            <input name="max_installments" type="hidden" value="1" />
            {/if}
            {if $mercadoenvios_available}
                {if isset($api_me.shipping_modes) and in_array('me2', $api_me.shipping_modes)}
                <ps-switch name="shipping_active" 
                    label="{l s='Enable MercadoEnvios' mod='mpmxs'}" 
                    yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                    {if isset($shipping_active) and $shipping_active}active="true"{/if}></ps-switch>
                <div id="form_mercadoenvios" {if !isset($shipping_active) || not $shipping_active}style="display:none"{/if}>
                    <ps-radios label="{l s='Calculation mode' mod='mpmxs'}">
                        <ps-radio name="shipping_calc_mode" value="sum_side" {if !isset($shipping_calc_mode) or $shipping_calc_mode == 'sum_side'}checked="true"{/if}>{l s='Use width and height longest of all. Adding depth of each product.' mod='mpmxs'}</ps-radio>
                        <ps-radio name="shipping_calc_mode" value="longer_side" {if isset($shipping_calc_mode) and $shipping_calc_mode == 'longer_side'}checked="true"{/if}>{l s='Use the longer sides of each product.' mod='mpmxs'}</ps-radio>
                    </ps-radios>
                    <ps-select name="exclude_client_groups[]" multiple="true" label="{l s='Exclude MercadoEnvios for this clients groups' mod='mpmxs'}">
                        {foreach from=$client_groups item=val}
                            <option value="{$val.id_group|escape:'htmlall':'UTF-8'}" {if isset($exclude_client_groups) and in_array($val.id_group, $exclude_client_groups)}data-selected="true"{/if}>{$val.name|escape:'htmlall':'UTF-8'}</option>
                        {/foreach}
                    </ps-select>
                    <ps-switch name="ship_check_price" 
                        label="{l s='Enable calculator of MercadoEnvios on product sheet' mod='mpmxs'}" 
                        yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                        {if isset($ship_check_price) and $ship_check_price}active="true"{/if}></ps-switch>
                    <ps-input-text name="default_weight" 
                        label="{l s='Weight default product (In grams)' mod='mpmxs'}"
                        help="{l s='Only numbers value, for example: 100' mod='mpmxs'}" size="10" 
                        value="{if isset($default_weight)}{$default_weight|escape:'htmlall':'UTF-8'}{/if}"
                        required-input="true" 
                        hint="{l s='Only numbers value, for example: 100' mod='mpmxs'}" fixed-width="lg"></ps-input-text>
                    
                    <ps-input-text name="default_width" 
                        label="{l s='Width default product (In centimeters)' mod='mpmxs'}"
                        help="{l s='Only numbers value, for example: 10' mod='mpmxs'}" size="10" 
                        value="{if isset($default_width)}{$default_width|escape:'htmlall':'UTF-8'}{/if}"
                        required-input="true" 
                        hint="{l s='Only numbers value, for example: 10' mod='mpmxs'}" fixed-width="lg"></ps-input-text>
                    
                    <ps-input-text name="default_height" 
                        label="{l s='Height default product (In centimeters)' mod='mpmxs'}"
                        help="{l s='Only numbers value, for example: 10' mod='mpmxs'}" size="10" 
                        value="{if isset($default_height)}{$default_height|escape:'htmlall':'UTF-8'}{/if}"
                        required-input="true" 
                        hint="{l s='Only numbers value, for example: 10' mod='mpmxs'}" fixed-width="lg"></ps-input-text>
                    
                    <ps-input-text name="default_depth" 
                        label="{l s='Depth default product (In centimeters)' mod='mpmxs'}"
                        help="{l s='Only numbers value, for example: 10' mod='mpmxs'}" size="10" 
                        value="{if isset($default_depth)}{$default_depth|escape:'htmlall':'UTF-8'}{/if}"
                        required-input="true" 
                        hint="{l s='Only numbers value, for example: 10' mod='mpmxs'}" fixed-width="lg"></ps-input-text>
                </div>
                {else}
                <ps-label-information>
                    <ps-alert-error><a href="{$settings.MPENVIOS_REGISTER_URL|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Click here for active MercadoEnvios in your account' mod='mpmxs'}</a></ps-alert-error>
                    <ps-alert-hint><a href="javascript:void($('#formKMP')[0].submit())">{l s='Reload this page if you have already registered successfully in MercadoEnvios.' mod='mpmxs'}</a></ps-alert-error>
                </ps-label-information>
                {/if}
            {/if}
            {if isset($test_user.seller) and isset($test_user.buyer)}
            <ps-label-information>
                <p>{l s='Active the test mode using the "Client ID" and "Secret ID" of "Seller Test User" and buy on the store using "Buyer Test User".' mod='mpmxs'}</p>
                <ul class="bulleted">
                    <li><p>{l s='MercadoPago Seller Test E-Mail' mod='mpmxs'}: <b>{$test_user.seller.email|escape:'htmlall':'UTF-8'}</b></p></li>
                    <li><p>{l s='MercadoPago Seller Test Password' mod='mpmxs'}: <b>{$test_user.seller.password|escape:'htmlall':'UTF-8'}</b></p></li>
                    <li><p>{l s='MercadoPago Buyer Test E-Mail' mod='mpmxs'}: <b>{$test_user.buyer.email|escape:'htmlall':'UTF-8'}</b></p></li>
                    <li><p>{l s='MercadoPago Buyer Test Password' mod='mpmxs'}: <b>{$test_user.buyer.password|escape:'htmlall':'UTF-8'}</b></p></li>
                </ul>
                <p>{l s='According to the payment method you use, you can generate the simulated payment report with a particular state.' mod='mpmxs'}</p>
                <p>{l s='Choose between different means of payment and generates a specific answer:' mod='mpmxs'} <a href="https://www.mercadopago.com.mx/developers/es/solutions/payments/basic-checkout/test/test-payments/" target="_blank">https://www.mercadopago.com.mx/developers/es/solutions/payments/basic-checkout/test/test-payments/</a></p>
            </ps-label-information>
            <ps-label-information>
                <ps-alert-warn><a href="{$settings.SECRET_URL|escape:'htmlall':'UTF-8'}" target="_blank">{l s='Search your client_id and client_secret here' mod='mpmxs'}</a></ps-alert-error>
            </ps-label-information>
            {/if}
            <ps-switch name="debug" 
                label="{l s='Actve Log, see log on:' mod='mpmxs'} {$log_path|escape:'htmlall':'UTF-8'}" 
                yes="{l s='Yes' mod='mpmxs'}" no="{l s='No' mod='mpmxs'}"
                {if isset($debug) && $debug}active="true"{/if}></ps-switch>
        {/if}
        <ps-panel-footer>
            <ps-panel-footer-submit title="{l s='Save changes' mod='mpmxs'}" icon="process-icon-save" direction="right" name="submitPanel"></ps-panel-footer-submit>
        </ps-panel-footer>

    </ps-panel>
</form>
